using System;

class Program
{
    static int CalculateBeauty(int[,] matrix, int K, int L)
    {
        int maxBeauty = 0;
        int N = matrix.GetLength(0);
        int M = matrix.GetLength(1);

        for (int i = 0; i <= N - K; i++)
        {
            for (int j = 0; j <= M - L; j++)
            {
                int subMatrixSum = 0;
                for (int p = i; p < i + K; p++)
                {
                    for (int q = j; q < j + L; q++)
                    {
                        subMatrixSum += matrix[p, q];
                    }
                }
                maxBeauty = Math.Max(maxBeauty, subMatrixSum);
            }
        }

        return maxBeauty;
    }

    static void Main()
    {
        string[] input = Console.ReadLine().Split();
        int N = int.Parse(input[0]);
        int M = int.Parse(input[1]);
        int K = int.Parse(input[2]);
        int L = int.Parse(input[3]);

        int[] elements = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);
        int[,] matrix = new int[N, M];

        int index = 0;
        for (int i = 0; i < N; i++)
        {
            for (int j = 0; j < M; j++)
            {
                matrix[i, j] = elements[index];
                index++;
            }
        }

        int result = CalculateBeauty(matrix, K, L);
        Console.WriteLine(result);
    }
}